/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.structure;

import com.google.common.collect.ImmutableList;
import com.izofar.bygonenether.world.structure.util.ModStructureUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NetherFortressStructure
extends Structure<NoFeatureConfig> {
    public static final List<MobSpawnInfo.Spawners> FORTRESS_ENEMIES = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200792_f, 10, 2, 3), (Object)new MobSpawnInfo.Spawners(EntityType.field_233592_ba_, 5, 4, 4), (Object)new MobSpawnInfo.Spawners(EntityType.field_200722_aA, 8, 5, 5), (Object)new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 2, 5, 5), (Object)new MobSpawnInfo.Spawners(EntityType.field_200771_K, 3, 4, 4), (Object)new MobSpawnInfo.Spawners(EntityType.field_200771_K, 4, 3, 3));
    private static final String FORTRESS_START_POOL = "fortress/start_pool";

    public NetherFortressStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return FORTRESS_ENEMIES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        return ModStructureUtils.isLavaLake(chunkGenerator, chunkX * 16, chunkZ * 16);
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            BlockPos centerPos = ModStructureUtils.getElevation(chunkGenerator, chunkX * 16, chunkZ * 16, 45, 54);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("bygonenether", NetherFortressStructure.FORTRESS_START_POOL)), 10), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = centerPos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = centerPos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
        }
    }
}

